﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0079_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

Try {
    $HistorySearchSettings = Get-ItemPropertyValue 'HKLM:\Software\Policies\Google\Chrome' -Name HistorySearchSettings
    if($HistorySearchSettings -eq 2){
        Log-Message -message "HistorySearchSettings configured value: $HistorySearchSettings"
        Exit 0
    } else {
        Log-Message -message "HistorySearchSettings configured incorrect value: $HistorySearchSettings"
        Exit 1
    }
} Catch {
    Log-Message -message "The property does not exist or an error occurred: $_"
    Exit 1
}